<?php
add_action( 'hook_for_time_sensitive_posts', 'manage_time_sensitive_posts' );

function manage_time_sensitive_posts() {
	global $wpdb;
	$wpdb->query( 
		$wpdb->prepare( "UPDATE $wpdb->posts SET `comment_status` = %s, `ping_status` = %s WHERE `post_date_gmt` < DATE_SUB(%s, INTERVAL %d DAY);", 
			array( 'closed', 'closed', current_time('mysql', 1), 31 ) 
		) 
	);
	
	$wpdb->query( 
		$wpdb->prepare( "UPDATE $wpdb->posts SET `post_status` = %s WHERE `post_type` = %s AND `post_date_gmt` < DATE_SUB(%s, INTERVAL %d DAY);", 
			array( 'private', 'competition', current_time('mysql', 1), 10 ) 
		) 
	);
}

if ( ! wp_next_scheduled( 'hook_for_time_sensitive_posts' ) ) {
    wp_schedule_event( current_time('timestamp'), 'daily', 'hook_for_time_sensitive_posts' );
}


?>